/*
 * Structures and definitions to support table-driven product information
 */

/* styles of xbar ID assignment */
enum lf_xbar_id_style {
  LF_XS_NONE,			/* no xbar id */
  LF_XS_SERIALX16,		/* linecard serial no * 16 + xbar_no */
  LF_XS_SAME			/* xbar ID = linecard serial no */
};

/* card types */
enum lf_linecard_type {
  LF_LC_TYPE_UNKNOWN,		/* unknown type */
  LF_LC_TYPE_COMM,		/* comm card (xbars, xcvrs, etc.) */
  LF_LC_TYPE_MONITOR,		/* monitoring linecard */
  LF_LC_TYPE_MECHANICAL,        /* power,fan*/
  LF_LC_TYPE_COUNT		/* number of types */
};

/*
 * enclosure definition
 */
struct lf_enclosure_def {

  char *product_id;		/* product ID of this definition */

  int num_slots;	/* total number of slots (lc + bp) */
  int num_pins;		/* number of pins per slot (maximum) */

  /* linecard info */
  int num_lc_slots;
  int lc_slotbase;

  /* backplane slot info */
  int num_bp_slots;
  int bp_slotbase;
  char *bp_product_id;

  struct lf_slot_conn **conn;	/* 2-d array of pin connections per slot */

  struct lf_enclosure_def *next;	/* we keep a list of all read */
};

/*
 * Connections for a backplane pin
 */
struct lf_slot_conn {
  int slot;
  int pin;
};

/*
 * linecard definitions
 */
struct lf_linecard_def {

  char *product_id;			/* product ID of this definition */
  enum lf_linecard_type lc_type;	/* card type */

  int num_pins;				/* number of pins to backplane */

  /* xbar info */
  int num_xbars;
  int num_xbar_ports;
  enum lf_xbar_id_style xbar_id_style;
  int qd_low_bit;			/* meaning of xbar control bits */
  int qd_high_bit;

  /* trransceiver info */
  int num_xcvrs;
  int num_xcvr_ports;
  int *xcvr_labels;		/* silkscreen label for each port */
  char *link_type;		/* fiber, copper, quad fiber, etc. */

  char *xcvr_port_string;  	/* string to look for in HTML output */

  		/* connection for each pin */
  struct lf_linecard_pin_conn *pin_conn;

		/* connections from xbars to xcvrs */
  struct lf_linecard_xbar_conn ***xbar_conn;

  struct lf_linecard_def *next;	/* we keep a list of all read */
};

/*
 * linecard pin connection
 */
struct lf_linecard_pin_conn {
  int is_xbar;			/* xbar connection if true, else xcvr */
  int index;			/* which one ? */
  int port;			/* which port ? */
};

/*
 * linecard xbar-xcvr connection
 */
struct lf_linecard_xbar_conn {
  int index;			/* which xcvr */
  int port;			/* which port */
};


/*
 * NIC definition
 */
struct lf_nic_def {
  char *product_id;

  int num_links;
  int num_xcvrs;
  int xcvr_ports;

  int ram_size;		/* in megabytes */

  struct lf_nic_def *next;
};


/*
 * prototypes
 */
struct lf_enclosure_def *lf_get_enclosure_definition(char *);
struct lf_linecard_def *lf_get_linecard_definition(char *);
struct lf_nic_def *lf_get_nic_definition(char *);
char *lf_product_id_alias(char *alias);
